/* ============ */
/* plancupn.c	*/
/* ============ */
#include <defcodes.h>
#include <miscdefs.h>
#include <cupnprob.c>

/* ==================================================================== */
/* PlanCupn - Prints Sample Sizes Required for Coupon Collector's Test	*/
/* ==================================================================== */
void
main()
{
    AbortGracefully();			/* Causes ^C to Behave */

    while (main)
    {
	int	k;
	char	*LeftLbl;
	int	CellExpect, MaxLength, SetSize;
	double	CouponProbs[100], TotalProb;

	GetInt("Enter Number of Unique Integers in Data Set:\t",
		&SetSize);
#define	DFLT_DATA_SET	10

	if (SetSize > 0)
	{
	    printf("Size of Data Set = %d\n", SetSize);
	}
	else
	{
	    SetSize = DFLT_DATA_SET;
	    printf("Data Set is set to %d Integers by default\n",
		SetSize);
	}

	for (;;)
	{
	    GetInt("Enter Maximum Length of a Segment:\t\t",
		&MaxLength);

	    if (MaxLength > SetSize)
	    {
		break;
	    }
	    printf("Number Must Exceed %d (Size of Data Set)\n",
		SetSize);
	}

	GetInt("Enter Minimum Expectation For Each Segment:\t",
		&CellExpect);

#define	DFLT_CELL_COUNT	5

	if (CellExpect > 0)
	{
	    printf("Minimum Cell Expectation = %d\n", CellExpect);
	}
	else
	{
	    CellExpect = DFLT_CELL_COUNT;
	    printf("Minimum Cell Expectation is set to %d by default\n",
		CellExpect);
	}
	CalcCouponProbs(SetSize, MaxLength, CouponProbs);

	printf("\nCoupon Probabilities:\nSeg Len     Pr%15s", "");
	printf("Cell Expectation     # Variates Required\n");

	TotalProb = 0;
	LeftLbl = ">= ";
	for (k = MaxLength - SetSize + 1; k >= 1; --k)
	{
	    double  DevReqd = ceil(0.5 + CellExpect/CouponProbs[k-1]);
	    printf("%3s%3d  %.11e%10s",
		LeftLbl, k+SetSize-1, CouponProbs[k-1], "");
	    printf("%5d%15s%5.f\n", CellExpect, "", DevReqd+k+SetSize-1);
	    TotalProb += CouponProbs[k-1];
	    LeftLbl = "";
	}

	printf("%26.11e  (Total)\n", TotalProb);
    }
}
